//LidHolesSwitchOnWall.scad;

//All walls are the same height;

//This module defines the holes for 
//the switch mounted on the wall of the case;
//It defines the hole objects;
//They don't become holes until used 
//in a difference() command 
//in the calling module;

include <BATT_Dimensions.scad>

module LidHolesSwitchOnWall()
{

echo("Begin LidHolesSwitchOnWall");

//The hole for the switch;
    
translate([OnOffHoleDeltaX, 
    OnOffHoleDeltaY, OnOffHoleDeltaZ])
cube([OnOffHoleX, OnOffHoleY, OnOffHoleZ], 
    center=true);

//The flange;
    
translate([OnOffFlangeDeltaX, 
    OnOffFlangeDeltaY, OnOffFlangeDeltaZ])
cube([OnOffFlangeX, OnOffFlangeY, OnOffFlangeZ], 
    center=true);

//Two screws;

translate([OnOffHoleDeltaX -OnOffScrewDeltaX, 
    WallInnerY/2 +WallThickness, 
    OnOffHoleDeltaZ])
rotate([90, 0, 0])
cylinder(h=OnOffScrewLength,
    d=OnOffScrewPhi, center=true, $fn=32);

translate([OnOffHoleDeltaX +OnOffScrewDeltaX, 
    WallInnerY/2 +WallThickness, 
    OnOffHoleDeltaZ])
rotate([90, 0, 0])
cylinder(h=OnOffScrewLength,
    d=OnOffScrewPhi, center=true, $fn=32);
    
}
//
